<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

    <head>
        <?php if(App\Utils\Ninja::isHosted()): ?>
            <!-- G Tag Manager -->
            <script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
            new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
            j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
            'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
            })(window,document,'script','dataLayer','GTM-WMJ5W23');</script>
            <!-- End G Tag Manager -->
        <?php endif; ?>
        <!-- Error: <?php echo e(session('error')); ?> -->
        <?php if(isset($company) && $company->matomo_url && $company->matomo_id): ?>
            <script>
                var _paq = window._paq = window._paq || [];
                /* tracker methods like "setCustomDimension" should be called before "trackPageView" */
                _paq.push(['trackPageView']);
                _paq.push(['enableLinkTracking']);
                <?php if(auth()->guard('contact')->check()): ?>
                _paq.push(['setUserId', '<?php echo e(auth()->guard('contact')->user()->present()->name()); ?>']);
                <?php endif; ?>
                (function() {
                var u="<?php echo e($company->matomo_url); ?>";
                _paq.push(['setTrackerUrl', u+'matomo.php']);
                _paq.push(['setSiteId', '<?php echo e($company->matomo_id); ?>']);
                var d=document, g=d.createElement('script'), s=d.getElementsByTagName('script')[0];
                g.async=true; g.src=u+'matomo.js'; s.parentNode.insertBefore(g,s);
                })();
            </script>
            <noscript><p><img src="<?php echo e($company->matomo_url); ?>/matomo.php?idsite=<?php echo e($company->matomo_id); ?>&amp;rec=1" style="border:0;" alt="" /></p></noscript>
        <?php elseif(config('services.analytics.tracking_id')): ?>
            <script async src="https://www.googletagmanager.com/gtag/js?id=UA-122229484-1"></script>
            <script>
                window.dataLayer = window.dataLayer || [];

                function gtag() {
                    dataLayer.push(arguments);
                }

                gtag('js', new Date());
                gtag('config', '<?php echo e(config('services.analytics.tracking_id')); ?>', {'anonymize_ip': true});

                function trackEvent(category, action) {
                    ga('send', 'event', category, action, this.src);
                }
            </script>
        <?php else: ?>
            <script>
                function gtag() {
                }
            </script>
        <?php endif; ?>

        <!-- Title -->
        <?php if(isset($account) && !$account->isPaid()): ?>
            <title><?php echo $__env->yieldContent('meta_title', ''); ?> — Invoice Ninja</title>
        <?php elseif(isset($company) && !is_null($company)): ?>
            <title><?php echo $__env->yieldContent('meta_title', ''); ?> — <?php echo e($company->present()->name()); ?></title>
        <?php else: ?>
            <title><?php echo $__env->yieldContent('meta_title', ''); ?></title>
        <?php endif; ?>

        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="description" content="<?php echo $__env->yieldContent('meta_description'); ?>"/>

        <!-- CSRF Token -->
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

        <!-- Scripts -->
        <?php echo app('Illuminate\Foundation\Vite')('resources/js/app.js'); ?>

        <!-- Fonts -->
        <style>
            @font-face {
              font-family: 'Open Sans';
              font-style: normal;
              font-weight: 400;
              font-stretch: 100%;
              font-display: swap;
              src: url( <?php echo e(asset('css/memSYaGs126MiZpBA-UvWbX2vVnXBbObj2OVZyOOSr4dVJWUgsjZ0B4gaVI.woff2')); ?>) format('woff2');
              unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD;
            }
        </style>

        <!-- Styles -->
        <?php echo app('Illuminate\Foundation\Vite')('resources/sass/app.scss'); ?>
        <?php if(auth()->guard('contact')->user() && !auth()->guard('contact')->user()->user->account->isPaid()): ?>
        
        <?php endif; ?>

        <link rel="canonical" href="<?php echo e(config('ninja.app_url')); ?>/<?php echo e(request()->path()); ?>"/>

        
        <?php echo $__env->yieldPushContent('head'); ?>

        <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::styles(); ?>


        <?php if((bool) \App\Utils\Ninja::isSelfHost() && isset($company)): ?>
            <style>
                <?php echo $company->settings->portal_custom_css; ?>

            </style>
        <?php endif; ?>
        <link rel="stylesheet" type="text/css" href="<?php echo e(asset('vendor/cookieconsent@3/cookieconsent.min.css')); ?>" defer>
    </head>

    <?php echo $__env->make('portal.ninja2020.components.primary-color', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <body class="antialiased <?php echo e($custom_body_class ?? ''); ?>">
        <?php if(session()->has('message')): ?>
            <div class="py-1 text-sm text-center text-white bg-primary disposable-alert">
                <?php echo e(session('message')); ?>

            </div>
        <?php endif; ?>

        <?php echo $__env->yieldContent('body'); ?>

        <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::scriptConfig(); ?> 

        <script src="<?php echo e(asset('vendor/cookieconsent@3/cookieconsent.min.js')); ?>" data-cfasync="false"></script>
        <script>
            window.addEventListener("load", function(){
                if (! window.cookieconsent) {
                    return;
                }
                window.cookieconsent.initialise({
                    "palette": {
                        "popup": {
                            "background": "#000"
                        },
                        "button": {
                            "background": "#f1d600"
                        },
                    },
                    "content": {
                        "href": "<?php echo e(config('ninja.privacy_policy_url.hosted')); ?>",
                        "message": "<?php echo e(ctrans('texts.cookie_message')); ?>",
                        "dismiss": "<?php echo e(ctrans('texts.got_it')); ?>",
                        "link": "<?php echo e(ctrans('texts.learn_more')); ?>",
                    }
                })}
            );
        </script>
    </body>

    <footer>
        <?php echo $__env->yieldContent('footer'); ?>
        <?php echo $__env->yieldPushContent('footer'); ?>
    </footer>

</html>
<?php /**PATH /var/www/app/resources/views/portal/ninja2020/layout/clean.blade.php ENDPATH**/ ?>