<div x-data="{ open: true }" style="display: none;" id="displayTermsModal" class="fixed bottom-0 inset-x-0 px-4 pb-4 sm:inset-0 sm:flex sm:items-center sm:justify-center">
    <div x-show="open" x-transition:enter="ease-out duration-300" x-transition:enter-start="opacity-0" x-transition:enter-end="opacity-100" x-transition:leave="ease-in duration-200" x-transition:leave-start="opacity-100" x-transition:leave-end="opacity-0" class="fixed inset-0 transition-opacity">
        <div class="absolute inset-0 bg-gray-500 opacity-75"></div>
    </div>

    <div x-show="open" x-transition:enter="ease-out duration-300" x-transition:enter-start="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95" x-transition:enter-end="opacity-100 translate-y-0 sm:scale-100" x-transition:leave="ease-in duration-200" x-transition:leave-start="opacity-100 translate-y-0 sm:scale-100" x-transition:leave-end="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95" class="bg-white rounded-lg px-4 pt-5 pb-4 overflow-hidden shadow-xl transform transition-all sm:max-w-lg sm:w-full sm:p-6">
        <div class="">
            <div class="mt-3 text-center sm:mt-0 sm:ml-4 sm:text-left">
                <h3 class="text-xl leading-6 font-medium text-gray-900">
                    <?php echo e(ctrans('texts.terms')); ?>

                </h3>
                <div class="mt-4 h-64 overflow-y-auto">
                    <?php $__currentLoopData = $entities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $entity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="mb-4">
                            <p class="text-sm leading-6 font-medium text-gray-500"><?php echo e($entity_type); ?> <?php echo e($entity->number); ?>:</p>
                            <?php if($variables && $entity->terms): ?>
                                <h5 data-ref="entity-terms"<?php echo $entity->parseHtmlVariables('terms', $variables); ?></h5>
                            <?php elseif($entity->terms): ?>
                                <h5 data-ref="entity-terms" class="text-sm leading-5 text-gray-900"><?php echo $entity->terms; ?></h5>
                            <?php else: ?>
                                <i class="text-sm leading-5 text-gray-500"><?php echo e(ctrans('texts.not_specified')); ?></i>
                            <?php endif; ?>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
        <div class="mt-5 sm:mt-4 sm:flex sm:flex-row-reverse">
            <div class="flex w-full rounded-md shadow-sm sm:ml-3 sm:w-auto" x-data>
                <button
                    type="button"
                    id="accept-terms-button"
                    onclick="setTimeout(() => this.disabled = true, 0); setTimeout(() => this.disabled = false, 5000); return true;"
                    class="button button-primary bg-primary">
                    <?php echo e(ctrans('texts.i_agree')); ?>

                </button>
            </div>
            <div class="mt-3 flex w-full rounded-md shadow-sm sm:mt-0 sm:w-auto" x-data>
                <button @click="document.getElementById('displayTermsModal').style.display = 'none';" type="button" class="button button-secondary" id="close-terms-button">
                    <?php echo e(ctrans('texts.close')); ?>

                </button>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('footer'); ?>
    <?php echo app('Illuminate\Foundation\Vite')('resources/js/clients/linkify-urls.js'); ?>
<?php $__env->stopPush(); ?>
<?php /**PATH /var/www/app/resources/views/portal/ninja2020/invoices/includes/terms.blade.php ENDPATH**/ ?>