<form action="<?php echo e(route('client.quotes.bulk')); ?>" method="post" id="approve-form">
<?php echo csrf_field(); ?>

<input type="hidden" name="action" value="approve">
<input type="hidden" name="process" value="true">
<input type="hidden" name="quotes[]" value="<?php echo e($quote->hashed_id); ?>">
<input type="hidden" name="signature">
<input type="hidden" name="user_input" value="">

<div class="bg-white shadow sm:rounded-lg">
    <div class="px-4 py-5 sm:p-6">
        <div class="sm:flex sm:items-start sm:justify-between">
            <div>

                <h3 class="text-lg leading-6 font-medium text-gray-900">
                    <?php echo e(ctrans('texts.approve')); ?>

                </h3>

                <div class="btn hidden md:block" data-clipboard-text="<?php echo e(url("client/quote/{$key}")); ?>" aria-label="Copied!">
                    <div class="flex text-sm leading-6 font-medium text-gray-500">
                        <p class="mr-2"><?php echo e(url("client/quote/{$key}")); ?></p>
                        <p><img class="h-5 w-5" src="<?php echo e(asset('assets/clippy.svg')); ?>" alt="Copy to clipboard"></p>
                    </div>
                </div>
            </div>

            <div class="mt-5 sm:mt-0 sm:ml-6 sm:flex-shrink-0 sm:flex sm:items-center">
                <?php echo $__env->yieldContent('quote-not-approved-right-side'); ?>

                <div class="inline-flex rounded-md shadow-sm">
                    <input type="hidden" name="action" value="approve">
                    <button onclick="setTimeout(() => this.disabled = true, 0); return true;" type="button"
                        class="button button-primary bg-primary"
                        id="approve-button"><?php echo e(ctrans('texts.approve')); ?></button>
                </div>
            </div>
        </div>
    </div>
</div>

</form>
<?php /**PATH /var/www/app/resources/views/portal/ninja2020/quotes/includes/actions.blade.php ENDPATH**/ ?>