<?php $__env->startSection('meta_title', ctrans('texts.view_invoice')); ?>

<?php $__env->startPush('head'); ?>
    <meta name="show-invoice-terms" content="<?php echo e($settings->show_accept_invoice_terms ? true : false); ?>">
    <meta name="require-invoice-signature" content="<?php echo e($client->user->account->hasFeature(\App\Models\Account::FEATURE_INVOICE_SETTINGS) && $settings->require_invoice_signature); ?>">
    <meta name="show-required-fields-form" content="<?php echo e(auth()->guard('contact')->user()->showRff()); ?>" />
    <?php echo $__env->make('portal.ninja2020.components.no-cache', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <script src="<?php echo e(asset('vendor/signature_pad@2.3.2/signature_pad.min.js')); ?>"></script>

<?php $__env->stopPush(); ?>

<?php $__env->startSection('header'); ?>
    <?php if($errors->any()): ?>
        <div class="alert alert-failure mb-4">
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <p><?php echo e($error); ?></p>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('body'); ?>

    <?php if($invoice->isPayable() && $client->getSetting('custom_message_unpaid_invoice')): ?>
        <?php $__env->startComponent('portal.ninja2020.components.message'); ?>
            <pre><?php echo e($client->getSetting('custom_message_unpaid_invoice')); ?></pre>
        <?php echo $__env->renderComponent(); ?>
    <?php elseif($invoice->status_id === 4 && $client->getSetting('custom_message_paid_invoice')): ?>
        <?php $__env->startComponent('portal.ninja2020.components.message'); ?>
            <pre><?php echo e($client->getSetting('custom_message_paid_invoice')); ?></pre>
        <?php echo $__env->renderComponent(); ?>
    <?php endif; ?>

    <?php if($invoice->isPayable()): ?>
        <form action="<?php echo e(($settings->client_portal_allow_under_payment || $settings->client_portal_allow_over_payment) ? route('client.invoices.bulk') : route('client.payments.process')); ?>" method="post" id="payment-form">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="invoices[]" value="<?php echo e($invoice->hashed_id); ?>">
            <input type="hidden" name="action" value="payment">

            <input type="hidden" name="company_gateway_id" id="company_gateway_id">
            <input type="hidden" name="payment_method_id" id="payment_method_id">
            <input type="hidden" name="signature">
            <input type="hidden" name="hash" value="<?php echo e($hash); ?>">
            <input type="hidden" name="payable_invoices[0][amount]" value="<?php echo e($invoice->partial > 0 ?  \App\Utils\Number::formatValue($invoice->partial, $invoice->client->currency()) : \App\Utils\Number::formatValue($invoice->balance, $invoice->client->currency())); ?>">
            <input type="hidden" name="payable_invoices[0][invoice_id]" value="<?php echo e($invoice->hashed_id); ?>">
            <input type="hidden" name="contact_first_name" value="<?php echo e(auth()->guard('contact')->user()->first_name); ?>">
            <input type="hidden" name="contact_last_name" value="<?php echo e(auth()->guard('contact')->user()->last_name); ?>">
            <input type="hidden" name="contact_email" value="<?php echo e(auth()->guard('contact')->user()->email); ?>">

            <div class="bg-white shadow sm:rounded-lg mb-4" translate>
                <div class="px-4 py-5 sm:p-6">
                    <div class="sm:flex sm:items-start sm:justify-between">
                        <div>
                            <h3 class="text-lg leading-6 font-medium text-gray-900">
                                <?php echo e(ctrans('texts.invoice_number_placeholder', ['invoice' => $invoice->number])); ?>

                                - <?php echo e(ctrans('texts.unpaid')); ?>

                            </h3>

                            <?php if($key): ?>
                            <div class="btn hidden md:block" data-clipboard-text="<?php echo e(url("client/invoice/{$key}")); ?>" aria-label="Copied!">
                                <div class="flex text-sm leading-6 font-medium text-gray-500">
                                    <p class="mr-2"><?php echo e(url("client/invoice/{$key}")); ?></p>
                                    <p><img class="h-5 w-5" src="<?php echo e(asset('assets/clippy.svg')); ?>" alt="Copy to clipboard"></p>
                                </div>
                            </div>
                            <?php endif; ?>


                        </div>
                        <div class="mt-5 sm:mt-0 sm:ml-6 flex justify-end">
                            <div class="inline-flex rounded-md shadow-sm">
                                <input type="hidden" name="invoices[]" value="<?php echo e($invoice->hashed_id); ?>">
                                <input type="hidden" name="action" value="payment">

                                <?php if($settings->client_portal_allow_under_payment || $settings->client_portal_allow_over_payment): ?>
                                    <button class="button button-primary bg-primary"><?php echo e(ctrans('texts.pay_now')); ?></button>
                                <?php else: ?>
                                    <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('pay-now-dropdown', ['total' => $invoice->getPayableAmount(), 'company' => $company]);

$__html = app('livewire')->mount($__name, $__params, 'lw-2757655001-0', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    <?php else: ?>
        <div class="bg-white shadow sm:rounded-lg mb-4">
            <div class="px-4 py-5 sm:p-6">
                <div class="sm:flex sm:items-start sm:justify-between">
                    <div>
                        <h3 class="text-lg leading-6 font-medium text-gray-900">
                            <?php echo e(ctrans('texts.invoice_number_placeholder', ['invoice' => $invoice->number])); ?>

                            - <?php echo e(\App\Models\Invoice::stringStatus($invoice->status_id)); ?>

                        </h3>

                            <?php if($key): ?>
                            <div class="btn hidden md:block" data-clipboard-text="<?php echo e(url("client/invoice/{$key}")); ?>" aria-label="Copied!">
                                <div class="flex text-sm leading-6 font-medium text-gray-500">
                                    <p class="pr-10"><?php echo e(url("client/invoice/{$key}")); ?></p>
                                    <p><img class="h-5 w-5" src="<?php echo e(asset('assets/clippy.svg')); ?>" alt="Copy to clipboard"></p>
                                </div>
                            </div>
                            <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <?php echo $__env->make('portal.ninja2020.components.entity-documents', ['entity' => $invoice], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('pdf-slot', ['entity' => $invoice, 'invitation' => $invitation, 'db' => $invoice->company->db]);

$__html = app('livewire')->mount($__name, $__params, 'lw-2757655001-1', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('footer'); ?>
    <?php echo $__env->make('portal.ninja2020.invoices.includes.required-fields', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('portal.ninja2020.invoices.includes.signature', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('portal.ninja2020.invoices.includes.terms', ['entities' => [$invoice], 'variables' => $variables, 'entity_type' => ctrans('texts.invoice')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('head'); ?>
    <?php echo app('Illuminate\Foundation\Vite')('resources/js/clients/invoices/payment.js'); ?>
    <script src="<?php echo e(asset('vendor/clipboard.min.js')); ?>" defer></script>

    <script type="text/javascript">

    document.addEventListener('DOMContentLoaded', () => {

        var clipboard = new ClipboardJS('.btn');

    });

    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('portal.ninja2020.layout.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/app/resources/views/portal/ninja2020/invoices/show.blade.php ENDPATH**/ ?>