<?php $__env->startSection('meta_title', ctrans('texts.login')); ?>

<?php $__env->startComponent('portal.ninja2020.components.test'); ?>
    <input type="hidden" id="test_email" value="<?php echo e(config('ninja.testvars.username')); ?>">
    <input type="hidden" id="test_password" value="<?php echo e(config('ninja.testvars.password')); ?>">
<?php echo $__env->renderComponent(); ?>

<?php $__env->startSection('body'); ?>
    <div class="grid lg:grid-cols-3 mx-6 md:mx-0">
        <?php if($account && !$account->isPaid()): ?>
            <div class="hidden lg:block col-span-1 bg-red-100 h-screen">
                <img src="<?php echo e(asset('images/client-portal-new-image.jpg')); ?>"
                     class="w-full h-screen object-cover"
                     alt="Background image">
            </div>
        <?php endif; ?>

        <div class="<?php echo e($account && !$account->isPaid() ? 'col-span-2' : 'col-span-3'); ?> h-screen flex">
            <div class="m-auto md:w-1/2 lg:w-1/4">
                <?php if($account && !$account->isPaid()): ?>
                    <div>
                        <img src="<?php echo e(asset('images/invoiceninja-black-logo-2.png')); ?>"
                             class="border-b border-gray-100 h-18 pb-4" alt="Invoice Ninja logo" id="company_logo">
                    </div>
                <?php elseif(isset($company) && !is_null($company)): ?>
                    <div>
                        <img src="<?php echo e($company->present()->logo()); ?>"
                             class="mx-auto border-b border-gray-100 h-18 pb-4" alt="<?php echo e($company->present()->name()); ?> logo">
                    </div>
                <?php endif; ?>

                <div class="flex flex-col">
                    <h1 class="text-center text-3xl"><?php echo e(ctrans('texts.client_portal')); ?></h1>
                    <form action="<?php echo e(route('client.login')); ?>" method="post" class="mt-6">
                        <?php echo csrf_field(); ?>
                        <div class="flex flex-col">
                            <label for="email" class="input-label"><?php echo e(ctrans('texts.email_address')); ?></label>
                            <input type="email" name="email" id="email"
                                   class="input"
                                   value="<?php echo e(old('email')); ?>"
                                   autofocus>
                            <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="validation validation-fail">
                                <?php echo e($message); ?>

                            </div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="flex flex-col mt-4">
                            <div class="flex justify-between items-center">
                                <label for="password" class="input-label"><?php echo e(ctrans('texts.password')); ?></label>
                                <a class="text-xs text-gray-600 hover:text-gray-800 ease-in duration-100"
                                   href="<?php echo e(route('client.password.request')); ?>"><?php echo e(trans('texts.forgot_password')); ?></a>
                            </div>
                            <?php if(isset($company) && !is_null($company)): ?>
                            <input type="hidden" name="company_key" value="<?php echo e($company->company_key); ?>">
                            <?php endif; ?>
                            <input type="password" name="password" id="password"
                                   class="input"
                                   autofocus>
                            <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="validation validation-fail">
                                <?php echo e($message); ?>

                            </div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="mt-5">
                            <button id="loginBtn" class="button button-primary button-block bg-blue-600">
                                <?php echo e(trans('texts.login')); ?>

                            </button>
                        </div>
                    </form>

                    <?php if(!is_null($company) && $company->client_can_register): ?>
                        <div class="mt-5 text-center">
                            <a class="button-link text-sm" href="<?php echo e(route('client.register')); ?>"><?php echo e(ctrans('texts.register_label')); ?></a>
                        </div>
                    <?php endif; ?>

                    <?php if(!is_null($company) && !empty($company->present()->website())): ?>
                        <div class="mt-5 text-center">
                            <a class="button-link text-sm" href="<?php echo e($company->present()->website()); ?>">
                                <?php echo e(ctrans('texts.back_to', ['url' => parse_url($company->present()->website())['host'] ?? $company->present()->website() ])); ?>

                            </a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('portal.ninja2020.layout.clean', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/app/resources/views/portal/ninja2020/auth/login.blade.php ENDPATH**/ ?>