<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

    <head>
        <!-- Error: <?php echo e(session('error')); ?> -->
        <?php if($company && $company->matomo_url && $company->matomo_id): ?>
            <script>
                var _paq = window._paq = window._paq || [];
                /* tracker methods like "setCustomDimension" should be called before "trackPageView" */
                _paq.push(['trackPageView']);
                _paq.push(['enableLinkTracking']);
                <?php if(auth()->guard('contact')->check()): ?>
                _paq.push(['setUserId', '<?php echo e(auth()->guard('contact')->user()->present()->name()); ?>']);
                <?php endif; ?>
                (function() {
                var u="<?php echo e($company->matomo_url); ?>";
                _paq.push(['setTrackerUrl', u+'matomo.php']);
                _paq.push(['setSiteId', '<?php echo e($company->matomo_id); ?>']);
                var d=document, g=d.createElement('script'), s=d.getElementsByTagName('script')[0];
                g.async=true; g.src=u+'matomo.js'; s.parentNode.insertBefore(g,s);
                })();
            </script>
            <noscript><p><img src="<?php echo e(auth()->guard('contact')->user()->company->matomo_url); ?>/matomo.php?idsite=<?php echo e(auth()->guard('contact')->user()->company->matomo_id); ?>&amp;rec=1" style="border:0;" alt="" /></p></noscript>
        <?php elseif(config('services.analytics.tracking_id')): ?>
            <script async src="https://www.googletagmanager.com/gtag/js?id=UA-122229484-1"></script>
            <script>
                window.dataLayer = window.dataLayer || [];

                function gtag() {
                    dataLayer.push(arguments);
                }

                gtag('js', new Date());
                gtag('config', '<?php echo e(config('services.analytics.tracking_id')); ?>', {'anonymize_ip': true});

                function trackEvent(category, action) {
                    ga('send', 'event', category, action, this.src);
                }
            </script>
        <?php else: ?>
            <script>
                function gtag() {
                }
            </script>
        <?php endif; ?>

        <!-- Title -->
        <?php if(isset($company->account) && !$company->account->isPaid()): ?>
            <title><?php echo $__env->yieldContent('meta_title', ''); ?> — Invoice Ninja</title>
        <?php elseif(isset($company) && !is_null($company)): ?>
            <title><?php echo $__env->yieldContent('meta_title', ''); ?> — <?php echo e($company->present()->name()); ?></title>
        <?php else: ?>
            <title><?php echo $__env->yieldContent('meta_title', ''); ?></title>
        <?php endif; ?>

        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="description" content="<?php echo $__env->yieldContent('meta_description'); ?>"/>

        <!-- CSRF Token -->
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

        <!-- Scripts -->
        <?php echo app('Illuminate\Foundation\Vite')('resources/js/app.js'); ?>

        <!-- Fonts -->
        <style>
            @font-face {
              font-family: 'Open Sans';
              font-style: normal;
              font-weight: 400;
              font-stretch: 100%;
              font-display: swap;
              src: url( <?php echo e(asset('css/memSYaGs126MiZpBA-UvWbX2vVnXBbObj2OVZyOOSr4dVJWUgsjZ0B4gaVI.woff2')); ?>) format('woff2');
              unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD;
            }
        </style>
        <!-- Styles -->
        <?php echo app('Illuminate\Foundation\Vite')('resources/sass/app.scss'); ?>

        <?php if(auth()->guard('contact')->user() && !auth()->guard('contact')->user()->user->account->isPaid()): ?>
            <link href="<?php echo e(asset('favicon.png')); ?>" rel="shortcut icon" type="image/png">
        <?php endif; ?>

        <link rel="canonical" href="<?php echo e(config('ninja.site_url')); ?>/<?php echo e(request()->path()); ?>"/>

        <?php if((bool) \App\Utils\Ninja::isSelfHost()): ?>
            <style>
                <?php echo $client->getSetting('portal_custom_css'); ?>

            </style>
        <?php endif; ?>

        <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::styles(); ?>


        
        <?php echo $__env->yieldPushContent('head'); ?>

        <?php if((isset($company) && $company->account->isPaid() && !empty($client->getSetting('portal_custom_head'))) || ((bool) \App\Utils\Ninja::isSelfHost() && !empty($client->getSetting('portal_custom_head')))): ?>
            <div class="py-1 text-sm text-center text-white bg-primary">
                <?php echo $client->getSetting('portal_custom_head'); ?>

            </div>
        <?php endif; ?>

        <link rel="stylesheet" type="text/css" href="<?php echo e(asset('vendor/cookieconsent@3/cookieconsent.min.css')); ?>" />
    </head>

    <?php echo $__env->make('portal.ninja2020.components.primary-color', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <body class="antialiased">
        <?php if(session()->has('message')): ?>
            <div class="py-1 text-sm text-center text-white bg-primary disposable-alert">
                <?php echo e(session('message')); ?>

            </div>
        <?php endif; ?>

        <?php $__env->startComponent('portal.ninja2020.components.general.sidebar.main'); ?>
            <?php echo $__env->yieldContent('body'); ?>
        <?php echo $__env->renderComponent(); ?>

        <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::scriptConfig(); ?> 

        <script src="<?php echo e(asset('vendor/cookieconsent@3/cookieconsent.min.js')); ?>" data-cfasync="false"></script>
        <script>
            window.addEventListener("load", function(){
                if (! window.cookieconsent) {
                    return;
                }
                window.cookieconsent.initialise({
                    "palette": {
                        "popup": {
                            "background": "#000"
                        },
                        "button": {
                            "background": "#f1d600"
                        },
                    },
                    "content": {
                        "href": "<?php echo e(config('ninja.privacy_policy_url.hosted')); ?>",
                        "message": "<?php echo e(ctrans('texts.cookie_message')); ?>",
                        "dismiss": "<?php echo e(ctrans('texts.got_it')); ?>",
                        "link": "<?php echo e(ctrans('texts.learn_more')); ?>",
                    }
                })}
            );
        </script>

        <?php if($company && $company->google_analytics_key): ?>
            <script>
                (function (i, s, o, g, r, a, m) {
                    i['GoogleAnalyticsObject'] = r;
                    i[r] = i[r] || function () {
                                (i[r].q = i[r].q || []).push(arguments)
                            }, i[r].l = 1 * new Date();
                    a = s.createElement(o),
                            m = s.getElementsByTagName(o)[0];
                    a.async = 1;
                    a.src = g;
                    m.parentNode.insertBefore(a, m)
                })(window, document, 'script', '//www.google-analytics.com/analytics.js', 'ga');

                ga('create', '<?php echo e($company->google_analytics_key); ?>', 'auto');
                ga('set', 'anonymizeIp', true);
                ga('send', 'pageview');

                function trackEvent(category, action) {
                    ga('send', 'event', category, action, this.src);
                }
            </script>
        <?php endif; ?>

    </body>

    <footer>
        <?php echo $__env->yieldContent('footer'); ?>
        <?php echo $__env->yieldPushContent('footer'); ?>

        <?php if($company && $company->account->isPaid() && !empty($client->getSetting('portal_custom_footer'))): ?>
            <div class="py-1 text-sm text-center text-white bg-primary">
                <?php echo $client->getSetting('portal_custom_footer'); ?>

            </div>
        <?php endif; ?>
    </footer>

    <?php if((bool) \App\Utils\Ninja::isSelfHost()): ?>
        <script>
            <?php echo $client->getSetting('portal_custom_js'); ?>

        </script>
    <?php endif; ?>
</html>
<?php /**PATH /var/www/app/resources/views/portal/ninja2020/layout/app.blade.php ENDPATH**/ ?>