<?php $__env->startSection('meta_title', ctrans('texts.entity_number_placeholder', ['entity' => ctrans('texts.quote'), 'entity_number' => $quote->number])); ?>

<?php $__env->startPush('head'); ?>
    <meta name="show-quote-terms" content="<?php echo e($settings->show_accept_quote_terms ? true : false); ?>">
    <meta name="require-quote-signature" content="<?php echo e($client->company->account->hasFeature(\App\Models\Account::FEATURE_INVOICE_SETTINGS) && $settings->require_quote_signature); ?>">
    <meta name="accept-user-input" content="<?php echo e($client->getSetting('accept_client_input_quote_approval')); ?>">
    <script src="<?php echo e(asset('vendor/signature_pad@2.3.2/signature_pad.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('body'); ?>

    <?php if(!$quote->isApproved() && $client->getSetting('custom_message_unapproved_quote')): ?>
        <?php $__env->startComponent('portal.ninja2020.components.message'); ?>
            <pre><?php echo e($client->getSetting('custom_message_unapproved_quote')); ?></pre>
        <?php echo $__env->renderComponent(); ?>
    <?php endif; ?>

    <?php if(in_array($quote->status_id, [\App\Models\Quote::STATUS_SENT, \App\Models\Quote::STATUS_DRAFT])): ?>
        <div class="mb-4">
            <?php echo $__env->make('portal.ninja2020.quotes.includes.actions', ['quote' => $quote], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    <?php elseif($quote->status_id == \App\Models\Quote::STATUS_CONVERTED): ?>

        <div class="bg-white shadow sm:rounded-lg mb-4">
            <div class="px-4 py-5 sm:p-6">
                <div class="sm:flex sm:items-start sm:justify-between">
                    <div>
                        <h3 class="text-lg leading-6 font-medium text-gray-900">
                            <?php echo e(ctrans('texts.approved')); ?>

                        </h3>

                            <?php if($key): ?>
                            <div class="btn hidden md:block" data-clipboard-text="<?php echo e(url("client/quote/{$key}")); ?>" aria-label="Copied!">
                                <div class="flex text-sm leading-6 font-medium text-gray-500">
                                    <p class="mr-2"><?php echo e(url("client/quote/{$key}")); ?></p>
                                    <p><img class="h-5 w-5" src="<?php echo e(asset('assets/clippy.svg')); ?>" alt="Copy to clipboard"></p>
                                </div>
                            </div>
                            <?php endif; ?>

                    </div>

                                <?php if($quote->invoice()->exists()): ?>
                                    <div class="mt-5 sm:mt-0 sm:ml-6 flex justify-end">
                                        <div class="inline-flex rounded-md shadow-sm">
                                            <a class="button button-primary bg-primary" href="/client/invoices/<?php echo e($quote->invoice->hashed_id); ?>"><?php echo e(ctrans('texts.view_invoice')); ?></a>
                                        </div>
                                    </div>
                                <?php endif; ?>
                </div>
            </div>
        </div>

    <?php elseif($quote->status_id == \App\Models\Quote::STATUS_APPROVED): ?>

        <div class="bg-white shadow sm:rounded-lg mb-4">
            <div class="px-4 py-5 sm:p-6">
                <div class="sm:flex sm:items-start sm:justify-between">
                    <div>
                        <h3 class="text-lg leading-6 font-medium text-gray-900">
                            <?php echo e(ctrans('texts.approved')); ?>

                        </h3>

                            <?php if($key): ?>
                            <div class="btn hidden md:block" data-clipboard-text="<?php echo e(url("client/quote/{$key}")); ?>" aria-label="Copied!">
                                <div class="flex text-sm leading-6 font-medium text-gray-500">
                                    <p class="mr-2"><?php echo e(url("client/quote/{$key}")); ?></p>
                                    <p><img class="h-5 w-5" src="<?php echo e(asset('assets/clippy.svg')); ?>" alt="Copy to clipboard"></p>
                                </div>
                            </div>
                            <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

    <?php else: ?>

        <div class="bg-white shadow sm:rounded-lg mb-4">
            <div class="px-4 py-5 sm:p-6">
                <div class="sm:flex sm:items-start sm:justify-between">
                    <div>
                        <h3 class="text-lg leading-6 font-medium text-gray-900">
                            <?php echo e(ctrans('texts.expired')); ?>

                        </h3>

                            <?php if($key): ?>
                            <div class="btn hidden md:block" data-clipboard-text="<?php echo e(url("client/quote/{$key}")); ?>" aria-label="Copied!">
                                <div class="flex text-sm leading-6 font-medium text-gray-500">
                                    <p class="mr-2"><?php echo e(url("client/quote/{$key}")); ?></p>
                                    <p><img class="h-5 w-5" src="<?php echo e(asset('assets/clippy.svg')); ?>" alt="Copy to clipboard"></p>
                                </div>
                            </div>
                            <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <?php echo $__env->make('portal.ninja2020.components.entity-documents', ['entity' => $quote], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('pdf-slot', ['entity' => $quote, 'invitation' => $invitation, 'db' => $quote->company->db]);

$__html = app('livewire')->mount($__name, $__params, 'lw-2851921883-0', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('footer'); ?>
    <?php echo $__env->make('portal.ninja2020.quotes.includes.user-input', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('portal.ninja2020.invoices.includes.terms', ['entities' => [$quote], 'variables' => $variables, 'entity_type' => ctrans('texts.quote')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('portal.ninja2020.invoices.includes.signature', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('head'); ?>
    <?php echo app('Illuminate\Foundation\Vite')('resources/js/clients/quotes/approve.js'); ?>
    <script src="<?php echo e(asset('vendor/clipboard.min.js')); ?>" defer></script>

    <script type="text/javascript" defer>

    document.addEventListener('DOMContentLoaded', () => {

        var clipboard = new ClipboardJS('.btn');

    });

    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('portal.ninja2020.layout.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/app/resources/views/portal/ninja2020/quotes/show.blade.php ENDPATH**/ ?>