#!/bin/bash

# Define the container name
CONTAINER_NAME="dockerfiles_app_1"

# Define the path where the custom PHP ini file should be placed inside the container
CUSTOM_INI_PATH="/usr/local/etc/php/conf.d/invoice-ninja.ini"

# Create the custom ini file with the desired settings
echo "Creating custom PHP ini settings..."
cat << EOF > invoice-ninja.ini
post_max_size = 2000M
upload_max_filesize = 2000M
memory_limit = 256M
max_execution_time = 300
max_input_time = 600
EOF

echo "Copying custom PHP ini file to the container..."
# Copy the custom ini file to the container
docker cp invoice-ninja.ini $CONTAINER_NAME:$CUSTOM_INI_PATH

echo "Restarting the container to apply changes..."
# Restart the container to apply the changes
docker restart $CONTAINER_NAME

echo "Custom PHP ini settings applied successfully."

